{
Progam is used for Center Search purpose  

This program generate 1D radial intensity curve from ED image
Before start of this program you need to generate Ratio image
with "General_RATany4F.v"

Progam will ask to select image for processing, and it should be open on on desktop

Progam will ask to select initialization file located in directory specified with constant "P"

All modification of the center, and file directory structure should be modified in initialization file

Passed parameters from <XXX>.ini

Center:
------------->> lines from <XXX>.ini
::
[Center]
cX=249
cY=258.0
::
<<-------------- 

Directory structure:
------------->> lines from <XXX>.ini
::
[Paths]

PathU=D:\DATA\Utilities\   				 --> read a path for Masks
PathR=D:\DATA\Utilities\XYarrayNEW\		 --> read a path for polar image
Path=D:\DATA\11012002\Mean\		   		 --> read a base path
::
::
Center=CenterGS\						 --> read a path for output file
::
<<--------------  



------------->> lines from <XXX>.ini
::
[Images]
:: 
Mask=M512.tif		  	   				 --> binary Mask image
::
AppMask=M512.tif						 --> binary apparatus Mask (could be different) 
::
::
<<--------------  

Output file saved in directory <Path><Center> with extention CSV
Naming convention:
<"x"><cX*10><"y"><cY*10><image name>.csv

cX*10 --> lable for center coordinate in X multiplied by factor of 10
cY*10 --> lable for center coordinate in Y multiplied by factor of 10  

File contains four columns:
1st column <pix>   	--> pixel number from the center
2nd column <FULL>  	--> 1D averaged intensity curve over FULL image
3nd column <LEFT>   --> 1D averaged intensity curve over LEFT half of the image
4th column <RIGHT>	--> 1D averaged intensity curve over RIGHT half of the image

created 13/01/2002 by V.Lobastov Ver. 08.}


const
  	 Prompt = 'Select an image for calculation' ;
	 P ='D:\DATA\Utilities\Delays\*.ini'; 		 	  //default directory for INI file  
//  	 P = 'D:\DATA\04072001\*.ini';	 

var
   Sel;	 			   			   //selector constant for initialization file
   Path;						   //Path constant for a base path
   PathU;						   //Path constant for a path for Masks
   PathR; 						   //Path constant for a path for polar image	
   PathC;  	                       //Paths constant for a path output file

 
 
   
   Size_x, Size_y;				   //image size constants
   F;					 		   //field image variables for full, left, and right halves CCD
   Image_I;                        //Input ED Image
   i, j;						   //indices
   Start;						   //start index for calculation

   Mask_II;                        //Image Intensifier Mask Image
   Fuss;						   //image of the apparatus imperfections
   FName;                          //Output filename
   Ed1;                            //Output ASCII file




	Data;						   //output ASCII array
	SamName;					   //name of the file
	X0,Y0;					   	   //center coordinates
	RR;  						   //name for polar array

	M512, M512L, M512R, M512LC, M512RC;	//mask images names
   	AppMask;						   //apparatus mask file for defect, hot spots etc.
	MLC,MRC, ML, MR; 						//mask images	  
	
{

******************************************************************
********************** function Select ***************************
******************************************************************
This function return a full file name for a file 
}	 	 

function SELECT;											
		var
   		   nName; Name, ix;
     		   Choice, nDIR;
		begin
	 		 Name:=FindFirstFile(P, fa_Archive);
	 		 nName:=ExtractFileName(Name);		
	 		 nDIR:= ExtractFilePath(Name);			//extract the path
			 ix:=0;
	  		 
			 while StrLen(Name) > 0 do

	  		 	   begin
	  	   		   		Name:=ExtractFileName(FindNextFile) ;
		   				nName:=nName+';'+Name;
					 if ix>100 then halt('Too many files in Directory');   
					 	ix:=ix+1;
	 				end; 

	 			 if SelectString( 'Select File',nName , Choice ) >= 0 then
	 			 	begin
			 			 SELECT:=nDIR+Choice;
	 				end	
	 			else
	 				begin 
	 	 	  			  WriteInfo('No Selection made! Restart program! ');	
		 	  			  halt;
	 				end; 
		end;
//----------------------> end of function SELECT <-----------------------------------			


{
 ************************************************************************
 ***                                                                  ***
 ***	                      Procedure RAD							  ***
 ***																  ***
 ************************************************************************ 
This procedure generate polar coordinate image with center passed as input parameters 
 }  

procedure RAD(X_off,Y_off);

var
  Image_x, Image_y;                             {X- and Y-coordinate Ramp images}
  Image_R;                                      {Polar-field image (equal radius field)}
  i, j;											{indices}
  x,y;
  Ramp_X, Ramp_Y;                               {Ramp vectors}
  Full;											{image headers}


		  begin
				   Full:='x'+Str(Word(Round(10*X_off)))+'y'+Str(Word(Round(10*Y_off)));
		  	   	if FileExists(PathR+Full+'.tif') then
				begin
				   WriteStatus('File Already Exists  '+ Full);
				end   
				else   
		  		   begin
						  WriteStatus('X_off= '+Str(X_off)+ '  Y_off= '+Str(Y_off));
                          Ramp_X:= Single(MakeLinear(0,Size_x,Size_x));
                          Ramp_Y:= Single(MakeLinear(0,Size_y,Size_y));
                                 Ramp_X:=Single(Ramp_X-X_off);
                                 Ramp_Y:=Single(Ramp_Y-Y_off);
                                 x:=Single(sqr(Ramp_X));
                                 y:=Single(sqr(Ramp_Y));
                          Image_x := CreateImage( Single, Size_x, Size_y ) ;
                          Image_y := CreateImage( Single, Size_x, Size_y );

                          Image_R:= CreateImage(Double, Size_x,Size_y);

 
           for j := 0 to (Size_x-1) do
                  begin
                          PutRow( Image_x, x, j ) ;
                      for i := 0 to (Size_y-1) do
                          PutColumn( Image_y, y, i );
                 end; 
                         Image_R:= Single(sqrt(Image_x+Image_y));
	   			   		 Save(Image_R,PathR+Full+'.tif');
							 
{------> Free memory}
                Free (Image_x);
                Free(Image_y);
                Free(Ramp_X);
                Free(Ramp_Y);
                Free(Image_R);
				Free(X_off);
				Free(Y_off);
			end;
		  end;  
  
{---------> end of procedure RAD}

{
 ************************************************************************
 ***                                                                  ***
 ***	                      function MeanOfRad(MM)				  ***
 ***																  ***
 ************************************************************************ 
This function will return and mean count of the ring at certain radius
and specified mask as in put parameter
 }  
function MeanOfRad(R_field, MM);
	var
	   F_Image, Masked_FF, F_pix;	
		
		 begin

               F_Image := ( R_field > i)  and (R_field <= i+1) and (MM) and (Fuss);  {binary ring of current radius}			   
                         F_pix:= Longint(SumOf(F_Image)); 	   	   			   {number of pixels}
                         Masked_FF:=Single(Image_I*F_Image);				   {intensity ring of current radius}	

                 if (F_pix = 0) then
                    begin
                         MeanOfRad:=0;
                    end
                 else
                        MeanOfRad:=Single(SumOf(Masked_FF)/F_pix); 	   			// mean count for current radius						
Free(F_Image);
Free(Masked_FF);
			end;

			 
//-------> end of function MeanOfRad(MM)
 
{
 ******************************************************************************
 ***                                                                  		***
 ***	                      Procedure RadialLR(R_Field, Mask_L, Mask_R)	***
 ***																  		***
 ****************************************************************************** 
This procedure converts 2D image in 1D intensity curve;
The polar coordinates passed as parameter;

 }  

procedure RadialLR(R_Field, Mask_L, Mask_R);

   
  begin

  
				   Start:=0;				{first pixel number}
						 Data := CreateArray( single, 4, Size_x) ;
						 if IsNull( Data ) then
				Begin
						 WriteError( 'Insufficient memory to create array!' ) ;
						 Halt;
				end
				else
				
          for i:=Start to Integer((Size_x)/2-1-Start) do  	 				//---------> start of loop
           begin											
				Data[0,i]:=Start+i;
				Data[1,i]:=MeanOfRad(R_Field,Mask_II);
				Data[2,i]:=MeanOfRad(R_Field,Mask_L);
				Data[3,i]:=MeanOfRad(R_Field,Mask_R);		 		
     WriteStatus('pix= ', Data[0,i], ' Rad_F= ', Data[1,i],  ' Rad_L= ', Data[2,i], ' Rad_R= ', Data[3,i]);
				
           end;									//----->end of loop

					 
{---------> Create Output ASCII file}
    	 Ed1:=CreateEditor(SamName+'_FLR');
         WriteLn(Ed1,'pix', ',', 'FULL', ',', 'LEFT', ',', 'RIGHT') ;
		  
     for j:=0 to Integer(Size_x/2-Start-1) do
	 begin
         Write(Ed1, ShortInt(Data[0,j]), ',', Data[1,j]:20:15, ',', Data[2,j]:20:15, ',', Data[3,j]:20:15) ;
         WriteLn(Ed1);
 	end;	 
		 Save(Ed1, Path +PathC + RR+SamName+'_FLR'+'.csv');

{------> Free memory}

		 Delete(R_field);
		 Delete(Mask_II);
		 Delete(Mask_L);
		 Delete(Mask_R);
		 Delete(Ed1);
		 Delete(Data) ;
end;

{---------> end of procedure Radial}

{
 ************************************************************************
 ************************************************************************
 ***                                                                  ***
 ***	                      Main program							  ***
 ***																  ***
 ************************************************************************ 
 ************************************************************************
}

begin

    {-------> Get Input Data Image}
                                        { check for images }
                   if GetNumImages = 0 then halt( 'This program requires a desktop image' ) ;

                            { select one of them }
                   SelectImage( Prompt,Image_I ) ;
                   if IsNull( Image_I ) then halt( 'No image was selected' ) ;
                   Size_x:=GetXSize(Image_I);
                   Size_y:=GetYSize(Image_I);
				   SamName:=GetName(Image_I);
				   
 {--------> Read Mask_II.tif image from HDD'
 updated with rejected points mask image
 

{------> Default center}
	 		Sel:=SELECT;												 // selector for initialization file
{------> Set Center coordinates}
						      				 	  						  
				 X0:=Val(ReadPrivateINIString( Sel, 'Center', 'cX'));	 //read a center coordinates for X
				 Y0:=Val(ReadPrivateINIString( Sel, 'Center', 'cY'));	 //read a center coordinates for Y
			
	 			 Path:= ReadPrivateINIString( Sel, 'Paths', 'Path');	 //read a base path
	 			 PathU:= ReadPrivateINIString( Sel, 'Paths', 'PathU');	 //read a path for Masks
				 PathR:=ReadPrivateINIString( Sel, 'Paths', 'PathR');	 //read a path for polar image				 	

				 PathC:=ReadPrivateINIString( Sel, 'Paths', 'Center');	 //read a path for output file

				 if (StrLen(FindFirstFile( Path+PathC+'*.csv', fa_Archive)) = 0) then				 
				 CreateDir(Path+PathC);		 		  				 	   	  		//create directory for output

//-----------> definition for Mask Images
 
				 M512:=ReadPrivateINIString( Sel, 'Images', 'Mask');  	  		 //read a mask file name			 
				 AppMask:=ReadPrivateINIString( Sel, 'Images', 'AppMask'); 		//apparatus mask

				 M512L:=ReadPrivateINIString( Sel, 'Images', 'MaskL');  	  	 //read a mask file LEFT name
				 M512R:=ReadPrivateINIString( Sel, 'Images', 'MaskR');  	  	 //read a mask file RIGHT name
				 M512LC:=ReadPrivateINIString( Sel, 'Images', 'CentMaskL');    	 //read a mask file LEFT center part 				 
				 M512RC:=ReadPrivateINIString( Sel, 'Images', 'CentMaskR');    	 //read a mask file RIGHT center part

  {-------> Get Mask images}			
   		    		  Open(PathU + M512, Mask_II);					
                   if IsNull( Mask_II ) then halt( 'No Reference image was selected' ) ;

   		    		  Open(PathU + M512L, ML);					
                   if IsNull( ML ) then halt( 'No Reference image was selected' ) ;
   		    		  Open(PathU + M512R, MR);					
                   if IsNull( MR ) then halt( 'No Reference image was selected' ) ;
				   
   		    		  Open(PathU + M512LC, MLC);					
                   if IsNull( MLC ) then halt( 'No Reference image was selected' ) ;
   		    		  Open(PathU + M512RC, MRC);					
                   if IsNull( MRC ) then halt( 'No Reference image was selected' ) ;				 				 
//-------->get apparatus mask				 	 
 		    	   	  Open(PathU + AppMask,Fuss);							 
                   if IsNull( Fuss ) then halt( 'No Reference image was selected' ) ;

//--------->check an existing polar image or create one if there is none				   
					 RAD(X0,Y0);		 	   					
					 RR:='x'+Str(Word(Round(10*X0)))+'y'+Str(Word(Round(10*Y0)));						  

 		    		 Open(PathR+ RR+'.tif',F);						  
						  
 {-------> Open or select from desktop Polar coordinate image}
 		   		    RadialLR(F,ML,MR);
								
			        PlaySound( 'C:\Program Files\Digital Optics\V++\Library\Mac.wav' ) ;								
					WriteInfo('Calculation completed!');

	Free(Mask_II);
	Free(Fuss);
	Free(F);
	Free(ML);				
	Free(MR);
	Free(MLC);				
	Free(MRC);
	Free(Image_I);

end
